<?php

namespace AgeGate\Dev\Admin\Controller;

use AgeGate\Dev\Admin\Settings\Dev;
use AgeGate\Common\Admin\AbstractController;
use AgeGate\Common\Immutable\Constants as Immutable;

class DevController extends AbstractController
{
    use Dev;

    public const PERMISSION = Immutable::ACCESS;
    public const OPTION = 'age_gate_dev';

    public function register(): void
    {
        $this->menu('Development options', self::PERMISSION, 'Development');
    }

    protected function required(): bool
    {
        return current_user_can(self::PERMISSION);
    }

    public function data(): array
    {
        return get_option(self::OPTION, []) ?: [];
    }

    protected function fields(): array
    {
        return $this->getDevFields();
    }

    protected function optionStored($data) : void
    {
        delete_site_transient('update_plugins');
    }
}